package com.blogspot.m3g4h4rd;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;

import com.blogspot.m3g4h4rd.wicket.BooleanRadioGroup;
import com.blogspot.m3g4h4rd.wicket.CSSFeedbackContainer;
import com.blogspot.m3g4h4rd.wicket.ExtendedRadioGroup;

/**
 * Demonstrates the use of com.blogspot.m3g4h4rd.wicket.CSSComponentFeedbackContainer and
 * com.blogspot.m3g4h4rd.wicket.BooleanRadioGroup.<br/><br/>
 * 
 * The class implements a Wicket panel which consists of an entry mask for the account 
 * information of a bank or a postal account. Depending on the chosen account type different
 * entry fields are enabled or disabled.<br/><br/>
 * 
 * The user must enter either the information of a bank or postal account. It
 * is not allowed to enter nothing. In the case no account type is selected, a 
 * validation error shows that an account type must be selected. In the case,
 * an account type is selected but no information about the account is entered, 
 * a validation error of the corresponding fields occurs.
 * 
 * @author Silvio Meier
 */
public class AccountInformationPanel extends Panel {
	private static final long serialVersionUID = 1L;
	private CSSFeedbackContainer accountsFeedbackContainer;
	private BooleanRadioGroup accountRadioGroup;
	private Label accountInformationLabel;
	private Radio bankAccount;
	private Label bankAccountLabel;
	private Label bankAccountNumberLabel;
	private TextField bankAccountNumber;
	private Label bankAddressLabel;
	private Label bankAccountHolderLabel;
	private Radio postalAccount;
	private Label postalAccountLabel;
	private Label postalAccountNumberLabel;
	private Label postalAccountHolderLabel;
	private TextField bankAddress;
	private TextField bankAccountHolder;
	private TextField postalAccountHolder;
	private TextField postalAccountNumber;
	
	/**
	 * 
	 * @param id
	 */
	public AccountInformationPanel(String id) {
		super(id);
		initRadioGroupAndValidation();
		initBankAccountElements();
		initPostalAccountElements();
		initiallyDisableFields();
	}

	/**
	 * Initializes the Radio Group and its validation.
	 */
	protected void initRadioGroupAndValidation() {
		// initializes the feedback container
		accountsFeedbackContainer = new CSSFeedbackContainer("accountsFeedbackContainer", "errorFeedback");		
		this.add(accountsFeedbackContainer);
		
		// Set the components that will show a validation error feedback
		accountsFeedbackContainer.addErrorFeedbackComponetIds(new String[]{"bankAccountLabel", "postalAccountLabel"});
		// Set the components whose validation errors will be ignored by this component
		accountsFeedbackContainer.addIgnoredComponentIds(new String[]{"bankAddress", 
				"bankAccountNumber", 
				"bankAccountHolder", 
				"postalAccountNumber",
				"postalAccountHolder"});
		
		// user the boolean radio group
		// is the radio group which provides a selection for the 
		// two account types, i.e., postal and bank account.
		accountRadioGroup = new BooleanRadioGroup("accountRadioGroup", new Model(true)){
			@Override
			public void onSelectionChanged(Object o) {	
				if (this.getSelectedRadio() == bankAccount) {
					bankAccountNumber.setEnabled(true);
					bankAddress.setEnabled(true);
					bankAccountHolder.setEnabled(true);
					postalAccountNumber.setEnabled(false);					
					postalAccountHolder.setEnabled(false);
				} else if (this.getSelectedRadio() == postalAccount) {
					postalAccountNumber.setEnabled(true);					
					postalAccountHolder.setEnabled(true);
					bankAccountNumber.setEnabled(false);
					bankAddress.setEnabled(false);
					bankAccountHolder.setEnabled(false);
				}
			}
			
			// enable post back to the web server for selection change events
			@Override
			protected boolean wantOnSelectionChangedNotifications() {
        return true;
			}	
		};
		// one of the radio buttons must be selected...
		accountRadioGroup.setRequired(true);
		
		// 
		accountsFeedbackContainer.add(accountRadioGroup);
	}
	
	/**
	 * Initializes the bank account elements
	 */
	protected void initBankAccountElements() {
		// title label
		accountInformationLabel = new Label("accountInformationLabel",  new Model("Account Information:"));
		accountRadioGroup.add(accountInformationLabel);

		// bank account radio button and label
		bankAccount = new Radio("bankAccount", new Model(false));		
		accountRadioGroup.add(bankAccount);		
		bankAccountLabel = new Label("bankAccountLabel",  new Model("Bank Account"));
		accountRadioGroup.add(bankAccountLabel);
		
		// bank account number text field and label
		bankAccountNumberLabel = new Label("bankAccountNumberLabel", new Model("Account Number:"));
		bankAccountNumber = new TextField("bankAccountNumber");

		// feedback for validation errors of the bank account number
		CSSFeedbackContainer bankAccountNumberFeedback = new CSSFeedbackContainer("bankAccountNumberFeedback", "errorFeedback");
		accountRadioGroup.add(bankAccountNumberFeedback);
		bankAccountNumberFeedback.add(bankAccountNumber);
		bankAccountNumber.setRequired(true);
		accountRadioGroup.add(bankAccountNumberLabel);
		
		// bank address label and text field
		bankAddressLabel = new Label("bankAddressLabel", new Model("Address of Bank"));
		bankAddress = new TextField("bankAddress");
		
		// feedback for validation errors of the bank address
		CSSFeedbackContainer bankAddressFeedback = new CSSFeedbackContainer("bankAddressFeedback", "errorFeedback");		
		accountRadioGroup.add(bankAddressLabel);
		accountRadioGroup.add(bankAddressFeedback);
		bankAddressFeedback.add(bankAddress);
		bankAddress.setRequired(true);
		
		// bank account holder label and text field
		bankAccountHolderLabel = new Label("bankAccountHolderLabel", new Model("Account Holder:"));
		bankAccountHolder = new TextField("bankAccountHolder");
		
		// feedback container for bank account holder
		CSSFeedbackContainer bankAccountHolderFeedback = new CSSFeedbackContainer("bankAccountHolderFeedback", "errorFeedback");		
		accountRadioGroup.add(bankAccountHolderLabel);
		accountRadioGroup.add(bankAccountHolderFeedback);
		bankAccountHolderFeedback.add(bankAccountHolder);

		bankAccountHolder.setRequired(true);
	}
	
	/**
	 * Initializes the postal account fields. 
	 */
	protected void initPostalAccountElements() {
		// postal account radio button and label
		postalAccount = new Radio("postalAccount", new Model(false));
		accountRadioGroup.add(postalAccount);
		
		postalAccountLabel = new Label("postalAccountLabel",  new Model("Postal Account"));
		accountRadioGroup.add(postalAccountLabel);
		
		// postal account label and text field
		postalAccountNumberLabel = new Label("postalAccountNumberLabel", new Model("Account Number:"));
		postalAccountNumber = new TextField("postalAccountNumber");
		
		// container for showing any validation error of postal account numbers
		CSSFeedbackContainer postalAccountNumberFeedback = new CSSFeedbackContainer("postalAccountNumberFeedback", "errorFeedback");		
		accountRadioGroup.add(postalAccountNumberFeedback);
		postalAccountNumberFeedback.add(postalAccountNumber);		
		postalAccountNumber.setRequired(true);
		accountRadioGroup.add(postalAccountNumberLabel);
		
		// postal account label and text field
		postalAccountHolderLabel = new Label("postalAccountHolderLabel", new Model("Account Holder:"));
		postalAccountHolder = new TextField("postalAccountHolder");
		postalAccountHolder.setRequired(true);
		
		// container for showing any validation error of postal account holders
		CSSFeedbackContainer postalAccountHolderFeedback = new CSSFeedbackContainer("postalAccountHolderFeedback", "errorFeedback");		
		accountRadioGroup.add(postalAccountHolderLabel);
		accountRadioGroup.add(postalAccountHolderFeedback);
		postalAccountHolderFeedback.add(postalAccountHolder);
	}
	
	/**
	 * Initializes all text fields as diabled.
	 */
	protected void initiallyDisableFields() {		
		bankAccountNumber.setEnabled(false);
		bankAddress.setEnabled(false);
		bankAccountHolder.setEnabled(false);
		postalAccountNumber.setEnabled(false);					
		postalAccountHolder.setEnabled(false);
	}
}

