package com.blogspot.m3g4h4rd;

import java.util.Locale;

import org.apache.log4j.Logger;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;

import com.blogspot.m3g4h4rd.wicket.CSSFeedbackContainer;
import com.blogspot.m3g4h4rd.wicket.FeedbackPanel;
import org.apache.wicket.model.Model;

/**
 * The web page for demonstrating the Wicket extension 
 * components.
 * 
 * @author Silvio Meier
 */
public class TestCSSFeedback extends WebPage {
	
	/**
	 * The logging object for the test application.
	 */
	private static Logger LOG = Logger.getLogger(TestCSSFeedback.class);
	
	/**
	 * Iniializes the test application.
	 */
	public TestCSSFeedback() {
		
		// set the locale
		this.getSession().setLocale(Locale.ENGLISH);
		
		// include the css style sheet for the error class
		add(CSSPackageResource.getHeaderContribution("./layout.css"));

		// the form for the input
		Form form = new Form("form");
		this.add(form);
		
		// the feedback panel shows the error messages of any occured validation error
		FeedbackPanel fpanel = new FeedbackPanel("feedback");
		form.add(fpanel);
		
		// the name label and text field
		Label nameLabel = new Label("nameLabel",  new Model("Name:"));		
		TextField name = new TextField("name");
		name.setRequired(true);
		form.add(nameLabel);
		CSSFeedbackContainer nameFeedback = new CSSFeedbackContainer("nameFeedback","errorFeedback");
		nameFeedback.add(name);
		form.add(nameFeedback);
		
		
		// the first name label and text field
		Label firstNameLabel = new Label("firstNameLabel", new Model("First Name:"));
		TextField firstName = new TextField("firstName");
		firstName.setRequired(true);
		form.add(firstNameLabel);
		CSSFeedbackContainer firstNameFeedback = new CSSFeedbackContainer("firstNameFeedback","errorFeedback");
		firstNameFeedback.add(firstName);
		form.add(firstNameFeedback);
		
		// the panel for entering the account information
		AccountInformationPanel panel = new AccountInformationPanel("accountInformationPanel");
		form.add(panel);
		
		// the submit button
		Button button = new Button("submit", new Model("Submit")) {
			@Override
			public void onSubmit() {
				LOG.info("submit pressed");
				// here may be any action to process the 
				// submitted data
			}
		};
		form.add(button);
	}
}

